/*
 * Decompiled with CFR 0.152.
 */
package com.xlnt.utils.win32;

import com.xlnt.utils.Link;
import com.xlnt.utils.Ref;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public final class LinkWin32
extends Link {
    public String resolveLink(String filepath, Ref linkpath) {
        ArrayList<String> comp = new ArrayList<String>(16);
        int pos = 0;
        int last = 0;
        if (filepath.startsWith(":\\", 1)) {
            pos = 3;
        }
        if (filepath.startsWith("\\\\")) {
            pos = 2;
        }
        while (pos >= 0) {
            String c = (pos = filepath.indexOf(File.separator, pos + 1)) > 0 && pos < filepath.length() ? filepath.substring(last, pos) : filepath.substring(last);
            last = pos;
            if (c.equals(File.separator)) continue;
            comp.add(c);
        }
        String path = "";
        String link = null;
        Iterator i = comp.iterator();
        boolean resolve = true;
        while (i.hasNext()) {
            String c = (String)i.next();
            path = path + c;
            File f = new File(path);
            link = null;
            if (!resolve || f.exists() && !path.toLowerCase().endsWith(".lnk")) continue;
            try {
                String r = LinkWin32.readLnk(path);
                link = path;
                if (!link.toLowerCase().endsWith(".lnk")) {
                    link = link + ".lnk";
                }
                if (r.startsWith("\\") || r.startsWith(":\\", 1) || r.startsWith("\\\\")) {
                    path = r;
                    continue;
                }
                path = path + r;
            }
            catch (Exception e) {
                resolve = false;
            }
        }
        if (linkpath != null) {
            linkpath.set(link == null ? path : link);
        }
        return path;
    }

    public String resolveLink(String filepath) {
        return this.resolveLink(filepath, null);
    }

    public boolean createLink(String target, String path) {
        if (!path.toLowerCase().endsWith(".lnk")) {
            path = path + ".lnk";
        }
        try {
            LinkWin32.makeLink(target, path, null, null, null, null, 0);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean deleteLink(String path) {
        if (!path.toLowerCase().endsWith(".lnk")) {
            path = path + ".lnk";
        }
        return new File(path).delete();
    }

    public String ext() {
        return ".lnk";
    }

    public void createLink(String target, String path, String desc, String args, String cwd, String iconfile, int iconnr) throws Exception {
        if (!path.toLowerCase().endsWith(".lnk")) {
            path = path + ".lnk";
        }
        LinkWin32.makeLink(target, path, desc, args, cwd, iconfile, iconnr);
    }

    private static String readLnk(String filepath) throws Exception {
        if (!filepath.toLowerCase().endsWith(".lnk")) {
            filepath = filepath + ".lnk";
        }
        return LinkWin32.readLink(filepath);
    }

    private static native String readLink(String var0) throws Exception;

    private static native void makeLink(String var0, String var1, String var2, String var3, String var4, String var5, int var6) throws Exception;
}

